/*
 * Decompiled with CFR 0.152.
 */
package jade.core.messaging;

import jade.core.AID;
import jade.core.Profile;
import jade.core.messaging.GenericMessage;
import jade.core.messaging.MessageStorage;
import jade.lang.acl.ACLCodec;
import jade.lang.acl.StringACLCodec;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.codec.binary.Base64;

class FileMessageStorage
implements MessageStorage {
    private static final String RECEIVER_PREFIX = "AID-";
    private static final String MESSAGE_PREFIX = "MSG-";
    private static final String FOREVER = "FOREVER";
    private File baseDir;

    FileMessageStorage() {
    }

    public void init(Profile p) {
        String s = p.getParameter("persistent-delivery-basedir", null);
        if (s == null) {
            s = "." + File.separator + "PersistentDeliveryStore";
        }
        this.baseDir = new File(s);
        if (!this.baseDir.exists()) {
            this.baseDir.mkdir();
        }
    }

    public synchronized String store(GenericMessage msg, AID receiver) throws IOException {
        File subDir = this.getMessageFolder(receiver);
        File toStore = this.getMessageFile(subDir, msg, receiver);
        if (toStore.exists()) {
            this.incrementCounter(toStore);
        } else {
            this.createMessageFile(toStore, msg, receiver);
        }
        return toStore.getName();
    }

    public synchronized void delete(String storeName, AID receiver) throws IOException {
        File subDir = this.getMessageFolder(receiver);
        File toDelete = new File(subDir, storeName);
        this.decrementCounter(toDelete);
        if (subDir.list().length == 0) {
            subDir.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void loadAll(MessageStorage.LoadListener ll) throws IOException {
        ll.loadStarted("");
        File[] subdirs = this.baseDir.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() && f.getName().startsWith(FileMessageStorage.RECEIVER_PREFIX);
            }
        });
        int i = 0;
        block7: while (true) {
            if (i >= subdirs.length) {
                ll.loadEnded("");
                return;
            }
            File subdir = subdirs[i];
            File[] files = subdir.listFiles(new FileFilter(){

                public boolean accept(File f) {
                    return !f.isDirectory() && f.getName().startsWith(FileMessageStorage.MESSAGE_PREFIX);
                }
            });
            int j = 0;
            while (true) {
                block12: {
                    Object var20_21;
                    if (j >= files.length) {
                        ++i;
                        continue block7;
                    }
                    File toRead = files[j];
                    BufferedReader in = new BufferedReader(new FileReader(toRead));
                    String strHowMany = in.readLine();
                    long howMany = 1L;
                    try {
                        howMany = Long.parseLong(strHowMany);
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                    try {
                        try {
                            String encodedMsg = in.readLine();
                            ByteArrayInputStream istream = new ByteArrayInputStream(Base64.decodeBase64((byte[])encodedMsg.getBytes("US-ASCII")));
                            ObjectInputStream p = new ObjectInputStream(istream);
                            GenericMessage message = (GenericMessage)p.readObject();
                            istream.close();
                            StringACLCodec codec = new StringACLCodec(in, null);
                            AID receiver = codec.decodeAID();
                            int k = 0;
                            while ((long)k < howMany) {
                                ll.itemLoaded(toRead.getName(), message, receiver);
                                ++k;
                            }
                        }
                        catch (ACLCodec.CodecException ce) {
                            System.err.println("Error reading file " + toRead.getName() + " [" + ce.getMessage() + "]");
                            var20_21 = null;
                            in.close();
                            break block12;
                        }
                        catch (ClassNotFoundException cnfe) {
                            System.err.println("Error reading file " + toRead.getName() + " [" + cnfe.getMessage() + "]");
                            var20_21 = null;
                            in.close();
                            break block12;
                        }
                        var20_21 = null;
                    }
                    catch (Throwable throwable) {
                        var20_21 = null;
                        in.close();
                        throw throwable;
                    }
                    in.close();
                }
                ++j;
            }
            break;
        }
    }

    private File getMessageFolder(AID receiver) throws IOException {
        String hashedName = RECEIVER_PREFIX + receiver.hashCode();
        File folder = new File(this.baseDir, hashedName);
        if (!folder.exists()) {
            folder.mkdir();
        }
        return folder;
    }

    private File getMessageFile(File subDir, GenericMessage msg, AID receiver) throws IOException {
        long hc1 = receiver.hashCode();
        long hc2 = msg.toString().hashCode();
        String hashedName = MESSAGE_PREFIX + (hc1 * 2L + hc2);
        File message = new File(subDir, hashedName);
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void incrementCounter(File f) throws IOException {
        File tmp;
        block10: {
            BufferedReader in = new BufferedReader(new FileReader(f));
            tmp = File.createTempFile("JADE", ".tmp");
            String s = in.readLine();
            try {
                try {
                    long counter = Long.parseLong(s);
                    BufferedWriter out = new BufferedWriter(new FileWriter(tmp));
                    try {
                        s = Long.toString(++counter);
                        out.write(s, 0, s.length());
                        out.newLine();
                        s = in.readLine();
                        while (true) {
                            if (s == null) {
                                Object var9_8 = null;
                                break;
                            }
                            out.write(s, 0, s.length());
                            out.newLine();
                            s = in.readLine();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        out.close();
                        throw throwable;
                    }
                    out.close();
                    Object var11_11 = null;
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                    Object var11_12 = null;
                    in.close();
                    break block10;
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                in.close();
                throw throwable;
            }
            in.close();
        }
        f.delete();
        tmp.renameTo(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementCounter(File f) throws IOException {
        block6: {
            BufferedReader in = new BufferedReader(new FileReader(f));
            File tmp = File.createTempFile("JADE", ".tmp");
            String s = in.readLine();
            try {
                long counter = Long.parseLong(s);
                if (--counter == 0L) {
                    in.close();
                    f.delete();
                    break block6;
                }
                BufferedWriter out = new BufferedWriter(new FileWriter(tmp));
                try {
                    s = Long.toString(counter);
                    out.write(s, 0, s.length());
                    out.newLine();
                    s = in.readLine();
                    while (s != null) {
                        out.write(s, 0, s.length());
                        out.newLine();
                        s = in.readLine();
                    }
                    Object var9_8 = null;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    in.close();
                    out.close();
                    throw throwable;
                }
                in.close();
                out.close();
                f.delete();
                tmp.renameTo(f);
            }
            catch (NumberFormatException nfe) {
                in.close();
                nfe.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createMessageFile(File toStore, GenericMessage msg, AID receiver) throws IOException {
        BufferedWriter out = null;
        try {
            toStore.createNewFile();
            out = new BufferedWriter(new FileWriter(toStore));
            out.write("1", 0, 1);
            out.newLine();
            ByteArrayOutputStream ostream = new ByteArrayOutputStream();
            ObjectOutputStream p = new ObjectOutputStream(ostream);
            p.writeObject(msg);
            String strMessage = new String(Base64.encodeBase64((byte[])ostream.toByteArray()), "US-ASCII");
            ostream.close();
            out.write(strMessage, 0, strMessage.length());
            out.newLine();
            String strReceiver = receiver.toString();
            out.write(strReceiver, 0, strReceiver.length());
            out.newLine();
            Object var10_9 = null;
            if (out == null) return;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (out == null) throw throwable;
            out.close();
            throw throwable;
        }
        out.close();
    }
}

